/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.order;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.builder.PreparedSQLAppender;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.builder.StringSQLAppender;
import org.codefilarete.stalactite.query.builder.WhereSQLBuilderFactory;
import org.codefilarete.stalactite.query.model.ColumnCriterion;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Placeholder;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.UnitaryOperator;
import org.codefilarete.stalactite.query.model.ValuedVariable;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.ColumnVariable;
import org.codefilarete.stalactite.sql.order.MultiTableAwareDMLNameProvider;
import org.codefilarete.stalactite.sql.order.PlaceholderVariable;
import org.codefilarete.stalactite.sql.order.Update;
import org.codefilarete.stalactite.sql.order.WherableStatement;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.trace.MutableInt;

public class UpdateCommandBuilder<T extends Table<T>>
implements SQLBuilder {
    private final Update<T> update;
    private final Dialect dialect;
    private final MultiTableAwareDMLNameProvider dmlNameProvider;

    public UpdateCommandBuilder(Update<T> update, Dialect dialect) {
        this.update = update;
        this.dialect = dialect;
        this.dmlNameProvider = new MultiTableAwareDMLNameProvider(dialect.getDmlNameProviderFactory());
    }

    @Override
    public String toSQL() {
        StringSQLAppender sqlAppender = new StringSQLAppender(this.dmlNameProvider);
        this.appendUpdateStatement(sqlAppender, this.dmlNameProvider);
        return sqlAppender.getSQL();
    }

    private void appendUpdateStatement(SQLAppender result, MultiTableAwareDMLNameProvider dmlNameProvider) {
        this.appendUpdateStatement(result, result, dmlNameProvider);
    }

    private void appendUpdateStatement(SQLAppender setClauseAppender, SQLAppender criteriaAppender, MultiTableAwareDMLNameProvider dmlNameProvider) {
        setClauseAppender.cat("update ", new String[0]);
        LinkedHashSet whereColumns = new LinkedHashSet();
        this.update.getCriteria().forEach(c -> {
            if (c instanceof ColumnCriterion && ((ColumnCriterion)c).getColumn() instanceof Column) {
                whereColumns.add((Column)((ColumnCriterion)c).getColumn());
                Object condition = ((ColumnCriterion)c).getCondition();
                if (condition instanceof UnitaryOperator && ((UnitaryOperator)condition).getValue() instanceof ValuedVariable && ((ValuedVariable)((UnitaryOperator)condition).getValue()).getValue() instanceof Column) {
                    whereColumns.add((Column)((ValuedVariable)((UnitaryOperator)condition).getValue()).getValue());
                }
            }
        });
        Collection tablesInCondition = Iterables.collect(whereColumns, Column::getTable, HashSet::new);
        tablesInCondition.remove(this.update.getTargetTable());
        Collection additionalTables = tablesInCondition;
        dmlNameProvider.setMultiTable(!additionalTables.isEmpty());
        setClauseAppender.cat(dmlNameProvider.getName((Fromable)this.update.getTargetTable()), new String[0]).catIf(dmlNameProvider.isMultiTable(), ", ");
        Iterator iterator = additionalTables.iterator();
        while (iterator.hasNext()) {
            Table next = (Table)iterator.next();
            setClauseAppender.cat(dmlNameProvider.getName(next), new String[0]).catIf(iterator.hasNext(), ", ");
        }
        setClauseAppender.cat(" set ", new String[0]);
        Iterator columnIterator = this.update.getRow().stream().filter(ColumnVariable.class::isInstance).map(ColumnVariable.class::cast).iterator();
        while (columnIterator.hasNext()) {
            ColumnVariable c2 = (ColumnVariable)columnIterator.next();
            setClauseAppender.cat(dmlNameProvider.getName(c2.getColumn()), " = ");
            this.appendToSetClause(c2, setClauseAppender, dmlNameProvider);
            setClauseAppender.catIf(columnIterator.hasNext(), ", ");
        }
        if (!this.update.getCriteria().getConditions().isEmpty()) {
            criteriaAppender.cat(" where ", new String[0]);
            WhereSQLBuilderFactory.WhereSQLBuilder whereSqlBuilder = this.dialect.getQuerySQLBuilderFactory().getWhereBuilderFactory().whereBuilder(this.update.getCriteria(), dmlNameProvider);
            whereSqlBuilder.appendTo(criteriaAppender);
        }
    }

    protected void appendToSetClause(ColumnVariable<?, T> updateColumn, SQLAppender result, MultiTableAwareDMLNameProvider dmlNameProvider) {
        Object value = updateColumn.getValue();
        if (value instanceof Column) {
            result.cat(dmlNameProvider.getName((Column)value), new String[0]);
        } else {
            result.catValue(updateColumn.getColumn(), value);
        }
    }

    public UpdateStatement<T> toStatement() {
        final MutableInt variableCounter = new MutableInt();
        final HashMap columnIndexes = new HashMap();
        final HashMap<String, Set<Integer>> placeholderIndexes = new HashMap<String, Set<Integer>>();
        PreparedSQLAppender setValuesAppender = new PreparedSQLAppender(new StringSQLAppender(this.dmlNameProvider), this.dialect.getColumnBinderRegistry()){

            @Override
            public <V> PreparedSQLAppender catValue(@Nullable Selectable<V> column, Object value) {
                SQLAppender result = super.catValue((Selectable)column, value);
                columnIndexes.put((Column)column, variableCounter.increment());
                return result;
            }
        };
        PreparedSQLAppender criteriaAppender = new PreparedSQLAppender(new StringSQLAppender(this.dmlNameProvider), this.dialect.getColumnBinderRegistry()){

            @Override
            public <V> PreparedSQLAppender catValue(@Nullable Selectable<V> column, Object value) {
                SQLAppender result = super.catValue((Selectable)column, value);
                if (value instanceof Placeholder) {
                    placeholderIndexes.computeIfAbsent(((Placeholder)value).getName(), name -> new HashSet()).add(variableCounter.increment());
                }
                return result;
            }
        };
        this.appendUpdateStatement(setValuesAppender, criteriaAppender, this.dmlNameProvider);
        HashMap<Integer, Object> values = new HashMap<Integer, Object>(setValuesAppender.getValues());
        criteriaAppender.getValues().forEach((key, value) -> values.put(key + setValuesAppender.getValues().size(), value));
        Map<Integer, ParameterBinder<?>> parameterBinders = setValuesAppender.getParameterBinders();
        criteriaAppender.getParameterBinders().forEach((key, value) -> parameterBinders.put(key + setValuesAppender.getValues().size(), (ParameterBinder<?>)value));
        Iterator placeholderIterator = this.update.getRow().stream().filter(PlaceholderVariable.class::isInstance).map(PlaceholderVariable.class::cast).iterator();
        while (placeholderIterator.hasNext()) {
            PlaceholderVariable c = (PlaceholderVariable)placeholderIterator.next();
            Set indexes = (Set)placeholderIndexes.get(c.getName());
            if (indexes == null) {
                throw new IllegalArgumentException("No placeholder named \"" + c.getName() + "\" found in statement, available are " + placeholderIndexes.keySet());
            }
            indexes.forEach(index -> values.put((Integer)index, c.getValue()));
        }
        UpdateStatement result = new UpdateStatement(setValuesAppender.getSQL() + criteriaAppender.getSQL(), parameterBinders, columnIndexes, placeholderIndexes);
        result.setValues(values);
        return result;
    }

    public static class UpdateStatement<T extends Table<T>>
    extends PreparedSQL
    implements WherableStatement {
        private final Map<Column<T, Object>, Integer> columnIndexes;
        private final Map<String, Set<Integer>> placeholderIndexes;

        public UpdateStatement(String sql, Map<Integer, ? extends ParameterBinder<?>> parameterBinders, Map<? extends Column<T, ?>, Integer> columnIndexes, Map<String, Set<Integer>> placeholderIndexes) {
            super(sql, parameterBinders);
            this.columnIndexes = columnIndexes;
            this.placeholderIndexes = placeholderIndexes;
        }

        public void assertValuesAreApplyable() {
            super.assertValuesAreApplyable();
            Set presentPlaceholders = this.getValues().values().stream().filter(Placeholder.class::isInstance).map(Placeholder.class::cast).collect(Collectors.toSet());
            if (!presentPlaceholders.isEmpty()) {
                throw new IllegalStateException("Statement expect values for placeholders: " + presentPlaceholders.stream().map(Placeholder::getName).collect(Collectors.joining(", ")));
            }
        }

        public <O> void setValue(Column<T, O> column, O value) {
            Integer index = this.columnIndexes.get(column);
            if (index == null) {
                throw new IllegalArgumentException("Column " + column.getAbsoluteName() + " is not declared updatable with fixed value in the update clause");
            }
            this.setValue(index, value);
        }

        @Override
        public <O> void setValue(String placeholderName, O value) {
            Set<Integer> placeholderIndex = this.placeholderIndexes.get(placeholderName);
            if (placeholderIndex == null) {
                throw new IllegalArgumentException("Placeholder '" + placeholderName + "' is not declared as a criteria in the where clause");
            }
            placeholderIndex.forEach(index -> this.setValue(index, value));
        }
    }
}

